# USB Firmware Updater OSS Compliance Artifact

## Software Bill of Materials (SBOM)

| Component Name    | Version         | Supplier     | License    | Copyright Info                     | Download Location           | OSS Modification | OSS Source Code Disclosure | OSS Usage Method |
|-------------------|-----------------|--------------|------------|------------------------------------|-----------------------------|------------------|----------------------------|------------------|
| [libusb](libusb-download/libusb-1.0.22) | 1.0.22        | libusb.org   | LGPL-2.1   | Copyright (C) 2001-2019 libusb authors | https://github.com/libusb/libusb/releases/tag/v1.0.22 | Modified | Required | Dynamic linking with modifications for Sigmastar chip |
| MD5 Implementation | Custom          | Sigmastar    | Public Domain | Copyright (C) 2020-2021 Sigmastar | N/A | Not Modified | Not Applicable | Internal implementation for firmware verification |

## License Information

### GNU Lesser General Public License v2.1 (LGPLv2.1)
Applies to:
- libusb 1.0.22

Key terms:
- Allows linking with proprietary software
- Modifications to the library itself must be licensed under LGPLv2.1
- The library is provided "as is" without warranties
- Source code for modified version must be made available

### Public Domain
Applies to:
- MD5 Implementation (md5.c, md5.h)

Key terms:
- No copyright restrictions
- Can be freely used, modified and distributed
- No attribution required but recommended

## Copyright Information

### libusb
Copyright (c) 2001-2019 libusb authors

### MD5 Implementation
Copyright (c) 2020-2021 Sigmastar Technology

## License Agreements

### GNU Lesser General Public License, Version 2.1

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

## Source Code Disclosure

### libusb Modifications
The following modifications were made to the original libusb 1.0.22 library:

1. **SCSI Command Extensions**:
   - Added `do_sstar_scsi_command()` in [usbdownload-kernel.c](libusb-download\usbdownload-kernel.c) to handle Sigmastar-specific SCSI commands
   - Implemented Sigmastar-specific command opcodes:
     ```c
     #define SSTAR_USB_DOWNLOAD_KEEP  0x01
     #define SSTAR_USB_GET_RESULT     0x02
     #define SSTAR_USB_DOWNLOAD_END   0x04
     #define SSTAR_USB_LOAD_INFO      0x05
     #define SSTAR_USB_RUN_CMD        0x06
     ```

2. **Device State Detection**:
   - Extended `sstar_inquiry()` to detect Sigmastar device states:
     ```c
     enum {
         DEV_STATE_ROM = 0,
         DEV_STATE_UPDATER,
         DEV_STATE_UBOOT,
         DEV_STATE_UNKNOWN,
     };
     ```

3. **Custom Download Functions**:
   - Added `_download_bin()` and `_download_updater()` for firmware image handling
   - Implemented ROM-specific handling for P3 ROM U02

### Complete Modified Source Code
The complete modified source code for libusb is available in the `libusb-download/libusb/` directory of this project.

## Build Instructions

### Prerequisites
- Linux development environment
- libusb development files (if building on Linux)
- ARM cross-compiler (for target builds)

### Build Process
```bash
# Navigate to the project directory
cd libusb-download

# Build the USB firmware updater
make

# For cross-compilation (example for ARM)
CROSS_COMPILE=arm-linux-gnueabihf- make